package lac.contextnet.sddl_longrunningtest;


import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.infopae.model.SDDLLocation;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;

import java.util.ArrayList;
import java.util.List;

import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneAdapter;
import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneModel;
import lac.contextnet.sddl_longrunningtest.service.ConnectionListener;
import lac.contextnet.sddl_longrunningtest.service.ConnectionService;

import static android.support.v7.widget.RecyclerView.SCROLL_STATE_SETTLING;

/**
 * A simple {@link Fragment} subclass.
 */
public class SmartphoneFragment extends Fragment implements RecyclerArrayAdapter.OnLoadMoreListener, SwipeRefreshLayout.OnRefreshListener, View.OnClickListener {

    private EasyRecyclerView recyclerView;
    private SmartphoneAdapter adapter;
    private Handler handler = new Handler();

    private int page = 1;


    public static Fragment newInstance(String text) {
        SmartphoneFragment fragment = new SmartphoneFragment();
        return fragment;
    }

    public SmartphoneFragment() {
        // Required empty public constructor
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_smartphone, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        adapter = MainActivity.adapter;

        recyclerView = (EasyRecyclerView) view.findViewById(R.id.recycler_view);

        recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        recyclerView.setAdapterWithProgress(adapter);
        recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if(newState == SCROLL_STATE_SETTLING) {
                    adapter.notifyDataSetChanged();
                }
            }
        });

        adapter.setOnItemClickListener(new RecyclerArrayAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(int position) {
                Intent iService = new Intent(getContext(), ConnectionService.class);
                iService.putExtra("uuid", adapter.getItem(position).getTitle());
                getActivity().startService(iService);
            }
        });

        adapter.setMore(R.layout.view_more, this);
        adapter.setNoMore(R.layout.view_nomore);
        adapter.setError(R.layout.view_error).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                adapter.resumeMore();
            }
        });


        recyclerView.setRefreshListener(this);

        onRefresh();

    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }


    @Override
    public void onClick(View view) {
    }

    @Override
    public void onLoadMore() {
        final ArrayList<SmartphoneModel> list = new ArrayList<>();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                adapter.addAll(list);
            }
        }, 1000);
    }

    @Override
    public void onRefresh() {
        page = 1;
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                refreshList();
                onLoadMore();
            }
        }, 1000);
    }

    private void refreshList() {
        ArrayList<SmartphoneModel> list = new ArrayList<>();
        ArrayList<SDDLLocation> temp = ConnectionListener.receiveList;
        adapter.clear();

        if(temp != null && temp.size()>0) {
            for (SDDLLocation loc : ConnectionListener.receiveList) {
                String uuid = AppConfig.getUuid(getContext()).toString();
                if(!uuid.equalsIgnoreCase(loc.getUuid()))
                    list.add(new SmartphoneModel(getResources().getColor(R.color.deep_orange_400), loc.getUuid(), loc.getLatitude(), loc.getLongitude()));
                else
                    list.add(new SmartphoneModel(getResources().getColor(R.color.deep_purple_400), loc.getUuid(), loc.getLatitude(), loc.getLongitude()));
            }
        }
        adapter.addAll(list);
    }

}
